#include "system.h"

#include <dcmdlib.h>

#define GETOPT_TIMECHECK        1012
#define GETOPT_SHOWRC		1018


enum modes {
    MODE_UNKNOWN	= 0,
    MODE_DIRECTCTRL	= (1 <<   0),
    MODE_DIASHOW	= (1 <<   1),
    MODE_SHELL		= (1 <<   2),
    MODE_VERIFY		= (1 <<   3)
}


/* the flags for the various options */
static int	force;
static int	help;
static int	quiet;
static int	test;
static int	showrc;
static int	showHash;
static int	showPercents;
static int	showVersion;
static int	ioSpeed;
static char *	projName;
static char *	portTag;
static char *	modeTag;

#if 0
extern int	_ftp_debug;
static char *	ftpPort;
static char *	ftpProxy;
static char *	httpPort;
static char *	httpProxy;
#endif


/* the structure describing the options we take and the defaults */
static struct poptOption optionsTable[] = {
 { "control",	'c',  PORT_ARG_NONE,	NULL,		'c',			NULL, NULL},
 { "force",	'\0', POPT_ARG_NONE,	&force,		0,			NULL, NULL},
#if 0
 { "ftpdebug",	'\0', POPT_ARG_VAL,	&_ftp_debug,	-1,			NULL, NULL},
 { "ftpport",	'\0', POPT_ARG_STRING,	&ftpPort,	0,			NULL, NULL},
 { "ftpproxy",	'\0', POPT_ARG_STRING,	&ftpProxy,	0,			NULL, NULL},
#endif
 { "hash",	'h',  POPT_ARG_NONE,	&showHash,	0,			NULL, NULL},
 { "help",	'\0', POPT_ARG_NONE,	&help,		0,			NULL, NULL},
#if 0
 { "httpport",	'\0', POPT_ARG_STRING,	&httpPort,	0,			NULL, NULL},
 { "httpproxy",	'\0', POPT_ARG_STRING,	&httpProxy,	0,			NULL, NULL},
#endif
 { "mode",	'\0', POPT_ARG_STRING,	&modeTag,	0,			NULL, NULL},
 { "percent",	'\0', POPT_ARG_NONE,	&showPercents,	0,			NULL, NULL},
 { "projector",	'\0', POPT_ARG_STRING,	&projName,	0,			NULL, NULL},
 { "port",	'\0', POPT_ARG_STRING,	&portTag,	0,			NULL, NULL},
 { "quiet",	'\0', POPT_ARG_NONE,	&quiet,		0,			NULL, NULL},
 { "rcfile",	'\0', POPT_ARG_STRING,	&rcfile,	0,			NULL, NULL},
 { "shell",	'S',  POPT_ARG_NONE,	NULL,		'S',			NULL, NULL},
 { "show",	's',  POPT_ARG_NONE,	NULL,		's',			NULL, NULL},
 { "showrc",	'\0', POPT_ARG_NONE,	&showrc,	GETOPT_SHOWRC,		NULL, NULL},
 { "speed",	'\0', POPT_ARG_INT,	&ioSpeed,	0,			NULL, NULL},
 { "test",	'\0', POPT_ARG_NONE,	&test,		0,			NULL, NULL},
 { "timecheck",	'\0', POPT_ARG_STRING,	NULL,		GETOPT_TIMECHECK,	NULL, NULL},
 { "verbose",	'v',  POPT_ARG_NONE,	NULL,		'v',			NULL, NULL},
 { "verify",	'V',  POPT_ARG_NONE,	NULL,		'V',			NULL, NULL},
 {  NULL,	'y',  POPT_ARG_NONE,	NULL,		'V',			NULL, NULL},
 { "version",	'\0', POPT_ARG_NONE,	&showVersion,	0,			NULL, NULL},

// { NULL,	'\0', POPT_ARG_INCLUDE_TABLE, 
//		rpmQVSourcePoptTable, 0, (void *) &rpmQVArgs, NULL },
// { NULL,	'\0', POPT_ARG_INCLUDE_TABLE, 
//		rpmQueryPoptTable, 0, (void *) &rpmQVArgs, NULL },
// { NULL,	'\0', POPT_ARG_INCLUDE_TABLE, 
//		rpmVerifyPoptTable, 0, (void *) &rpmQVArgs, NULL },
// { NULL,	'\0', POPT_ARG_INCLUDE_TABLE, 
//		rpmBuildPoptTable, 0, (void *) &rpmBArgs, NULL },

 { 0, 0, 0, 0, 0, NULL, NULL }
};

#ifdef __MINT__
/* MiNT cannot dynamically increase the stack.  */
long _stksize = 64 * 1024L;
#endif

static void argerror(char * desc) {
    fprintf(stderr, _("diacmd: %s\n"), desc);
    exit(EXIT_FAILURE);
}

static void printHelp(void);
static void printVersion(void);
static void printBanner(void);
static void printUsage(void);
static void printHelpLine(char * prefix, char * help);

static void printVersion(void) {
    fprintf(stdout, _("DIAcmd version %s\n"), "0.0.0");
}

static void printBanner(void) {
    puts(_("Copyright (C) 2001 - Li-Pro.Net"));
    puts(_("This may be freely redistributed under the terms of the GNU GPL"));
}

static void printUsage(void) {
    printVersion();
    printBanner();
    puts("");

    puts(_("usage: diacmd {--help}"));
    puts(_("       diacmd {--version}"));
    puts(_("       diacmd {--control -c} [-v] [--hash -h] [--percent] [--force] [--test]"));
    puts(_("                             [--ftpproxy <host>] [--ftpport <port>]"));
    puts(_("                             [--httpproxy <host>] [--httpport <port>]"));
    puts(_("                             [--port <tag>] [--mode <tag>] [--speed <number>]"));
    puts(_("                             --projector <name> cmd1 ... cmdN"));
    puts(_("       diacmd {--show -s}    I THINK ABOUT :-) ..."));
    puts(_("       diacmd {--shell -S}   I THINK ABOUT :-) ..."));
}

static void printHelpLine(char * prefix, char * help) {
    int indentLength = strlen(prefix) + 3;
    int lineLength = 79 - indentLength;
    int helpLength = strlen(help);
    char * ch;
    char format[10];

    fprintf(stdout, "%s - ", prefix);

    while (helpLength > lineLength) {
	ch = help + lineLength - 1;
	while (ch > help && !isspace(*ch)) ch--;
	if (ch == help) break;		/* give up */
	while (ch > (help + 1) && isspace(*ch)) ch--;
	ch++;

	sprintf(format, "%%.%ds\n%%%ds", (int) (ch - help), indentLength);
	fprintf(stdout, format, help, " ");
	help = ch;
	while (isspace(*help) && *help) help++;
	helpLength = strlen(help);
    }

    if (helpLength) puts(help);
}

static void printHelp(void) {
    printVersion();
    printBanner();
    puts("");




    puts(         _("usage:"));


    printHelpLine(  "   --help                    ", 
		  _("print this message"));

    printHelpLine(  "   --version                 ",
		  _("print the version of rpm being used"));




    puts("");
    puts(         _("   all modes support the following arguments:"));

    printHelpLine(_("      --rcfile <file>        "),
		  _("use <file> instead of /etc/diacmdrc and $HOME/.diacmdrc"));

    printHelpLine(  "      -v                     ",
		  _("be a little more verbose"));

    printHelpLine(  "      -vv                    ",
		  _("be incredibly verbose (for debugging)"));




    puts("");
    puts(         _("   Direct control and dia shows allow ftp URL's to be used in place"));
    puts(         _("   of file names or command strings as well as the following options:"));

    printHelpLine(_("      --ftpproxy <host>      "),
		  _("hostname or IP of ftp proxy"));

    printHelpLine(_("      --ftpport <port>       "),
		  _("port number of ftp server (or proxy)"));

    printHelpLine(_("      --httpproxy <host>     "),
		  _("hostname or IP of http proxy"));

    printHelpLine(_("      --httpport <port>      "),
		  _("port number of http server (or proxy)"));




    puts("");
    puts(         _("      Information selection options:"));

    puts(           "         -h");
    printHelpLine(  "         --hash              ",
		  _("print hash marks as package installs (good with -v)"));

    printHelpLine(  "         --percent           ",
		  _("print percentages as package installs"));




    puts("");
    puts(         _("      Command control options:"));

    printHelpLine(  "         --force             ",
		  _("process unknown and inadmissible command strings too"));

    printHelpLine(  "         --test              ",
		  _("don't process, but tell if it would work or not"));




    puts("");
    puts(         _("      I/O specification options:"));

    printHelpLine(  "         --projector <name>  ",
		  _("use <name> to set --port, --mode, --speed and command string analysis"));

    printHelpLine(  "         --port <tag>        ",
		  _("use <tag> to set io port; overwrites the default set by --projector"));

    printHelpLine(  "         --mode <tag>        ",
		  _("use <tag> to set port's mode; overwrites the default set by --projector"));

    printHelpLine(  "         --speed <number>    ",
		  _("set port's working speed to <number>; overwrites the default set by --projector"));
}



int main(int argc, const char ** argv)
{
    enum modes		bigMode			= MODE_UNKNOWN;
    int			arg;
    int			directctrlFlags		= 0;
    int			interfaceFlags		= 0;
    int			probFilter		= 0;
    unsigned long int	timeCheck		= 0L;
    const char *	specFile;
    const char *	optArg;
    pid_t		pipeChild		= 0;
    char *		errString		= NULL;
    poptContext		optCon;
    const char *	infoCommand[]		= { "--info", NULL };
    const char *	installCommand[]	= { "--install", NULL };
    int			ec			= 0;
    int			status;
    int			p[2];

#if HAVE_MCHECK_H && HAVE_MTRACE
    mtrace();	/* Trace malloc only if MALLOC_TRACE=mtrace-output-file. */
#endif
    setprogname(argv[0]);	/* Retrofit glibc __progname */

    /* set the defaults for the various command line options */
    force = 0;
    help = 0;
    quiet = 0;
    test = 0;
    showrc = 0;
    showHash = 0;
    showPercents = 0;
    showVersion = 0;
    ioSpeed = 0;
    projName = NULL;
    portTag = NULL;
    modeTag = NULL;

#if 0
    _ftp_debug = 0;
    ftpProxy = NULL;
    ftpPort = NULL;
    httpProxy = NULL;
    httpPort = NULL;
#endif

#if 0
    /* set up the correct locale */
    setlocale(LC_ALL, "" );

#ifdef	__LCLINT__
#define	LOCALEDIR	"/usr/share/locale"
#endif
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif

    dcmdSetVerbosity(DCMDMESS_NORMAL);	/* XXX silly use by showrc */

    /* Make a first pass through the arguments, looking for --rcfile */
    /* We need to handle that before dealing with the rest of the arguments. */
    optCon = poptGetContext("diacmd", argc, argv, optionsTable, 0);
#if 0
    poptReadConfigFile(optCon, LIBDIACMDALIAS_FILENAME);
    poptReadDefaultConfig(optCon, 1);
    poptSetExecPath(optCon, RPMCONFIGDIR, 1);
#endif

    /* reading rcfile early makes it easy to override */
    /* XXX only --rcfile (and --showrc) need this pre-parse */

    while ((arg = poptGetNextOpt(optCon)) > 0) {
	switch(arg) {
	case 'v':
	    dcmdIncreaseVerbosity();	/* XXX silly use by showrc */
	    break;
        default:
	    break;
      }
    }

#if 0
    if (rpmReadConfigFiles(rcfile, NULL))  
	exit(EXIT_FAILURE);

    if (showrc) {
	rpmShowRC(stdout);
	exit(EXIT_SUCCESS);
    }
#endif

    dcmdSetVerbosity(DCMDMESS_NORMAL);	/* XXX silly use by showrc */

    poptResetContext(optCon);

    while ((arg = poptGetNextOpt(optCon)) > 0) {
	optArg = poptGetOptArg(optCon);

	switch (arg) {
	    
	  case 'c':
	    if (bigMode != MODE_UNKNOWN && bigMode != MODE_DIRECTCTRL)
		argerror(_("only one major mode may be specified"));
	    bigMode = MODE_DIRECTCTRL;
	    break;

	  case 's':
	    if (bigMode != MODE_UNKNOWN && bigMode != MODE_DIASHOW)
		argerror(_("only one major mode may be specified"));
	    bigMode = MODE_DIASHOW;
	    break;

	  case 'S':
	    if (bigMode != MODE_UNKNOWN && bigMode != MODE_SHELL)
		argerror(_("only one major mode may be specified"));
	    bigMode = MODE_SHELL;
	    break;

	  case 'V':
	  case 'y':
	    if (bigMode != MODE_UNKNOWN && bigMode != MODE_VERIFY)
		argerror(_("only one major mode may be specified"));
	    bigMode = MODE_VERIFY;
	    break;

	  case 'v':
	    dcmdIncreaseVerbosity();
	    break;

#if 0
	  case GETOPT_TIMECHECK:
	    tce = NULL;
	    timeCheck = strtoul(optArg, &tce, 10);
	    if ((*tce) || (tce == optArg) || (timeCheck == ULONG_MAX)) {
		argerror("Argument to --timecheck must be integer");
	    }
	    addMacro(NULL, "_timecheck", NULL, optArg, RMIL_CMDLINE);
	    addMacro(&rpmCLIMacroContext, "_timecheck", NULL, optArg, RMIL_CMDLINE);
	    timeCheck = 1;
	    break;
#endif

	  default:
	    fprintf(stderr, _("Internal error in argument processing (%d) :-(\n"), arg);
	    exit(EXIT_FAILURE);
	}
    }

    if (quiet)
	dcmdSetVerbosity(DCMDMESS_QUIET);

    if (showVersion) printVersion();
    if (help) printHelp();

    if (arg < -1) {
	fprintf(stderr, "%s: %s\n", 
		poptBadOption(optCon, POPT_BADOPTION_NOALIAS), 
		poptStrerror(arg));
	exit(EXIT_FAILURE);
    }

    if ((bigMode & (MODE_DIRECTCTRL | MODE_DIASHOW))
	&& (projName == NULL)) {
	argerror("missing name of dia projector I have to use");
    }

#if 0
    if (timeCheck && (bigMode & ~MODES_FOR_TIMECHECK))
	argerror(_("--timecheck may only be used during package builds"));
#endif

    if ((bigMode & ~(MODE_DIRECTCTRL | MODE_DIASHOW))
	&& force) {
	argerror(_("only direct control and dia show may be forced"));
    }

    if ((bigMode & ~(MODE_DIRECTCTRL | MODE_DIASHOW))
	&& showHash) {
	argerror(_("--hash (-h) may only be specified during direct "
		   "control and dia show"));
    }

    if ((bigMode & ~(MODE_DIRECTCTRL | MODE_DIASHOW))
	&& showPercents) {
	argerror(_("--percent may only be specified during direct "
		   "control and dia show"));
    }

    if ((bigMode & (MODE_SHELL | MODE_VERIFY))
	&& test) {
	argerror(_("--test may not be specified during shell"));
    }

#if 0
    if ((ftpProxy || ftpPort) && !(bigMode == MODE_INSTALL ||
	((bigMode == MODE_QUERY && QVSource == RPMQV_RPM)) ||
	((bigMode == MODE_VERIFY && QVSource == RPMQV_RPM))))
	argerror(_("ftp options can only be used during package queries, "
		 "installs, and upgrades"));

    if ((httpProxy || httpPort) && !(bigMode == MODE_INSTALL ||
	((bigMode == MODE_QUERY && QVSource == RPMQV_RPM)) ||
	((bigMode == MODE_VERIFY && QVSource == RPMQV_RPM))))
	argerror(_("http options can only be used during package queries, "
		 "installs, and upgrades"));

    if (ftpProxy) {
	addMacro(NULL, "_ftpproxy", NULL, ftpProxy, RMIL_CMDLINE);
	addMacro(&rpmCLIMacroContext, "_ftpproxy", NULL, ftpProxy, RMIL_CMDLINE);
    }
    if (ftpPort) {
	addMacro(NULL, "_ftpport", NULL, ftpPort, RMIL_CMDLINE);
	addMacro(&rpmCLIMacroContext, "_ftpport", NULL, ftpPort, RMIL_CMDLINE);
    }
    if (httpProxy) {
	addMacro(NULL, "_httpproxy", NULL, httpProxy, RMIL_CMDLINE);
	addMacro(&rpmCLIMacroContext, "_httpproxy", NULL, httpProxy, RMIL_CMDLINE);
    }
    if (httpPort) {
	addMacro(NULL, "_httpport", NULL, httpPort, RMIL_CMDLINE);
	addMacro(&rpmCLIMacroContext, "_httpport", NULL, httpPort, RMIL_CMDLINE);
    }
#endif

#if 0
    if (pipeOutput) {
	pipe(p);

	if (!(pipeChild = fork())) {
	    close(p[1]);
	    dup2(p[0], STDIN_FILENO);
	    close(p[0]);
	    execl("/bin/sh", "/bin/sh", "-c", pipeOutput, NULL);
	    fprintf(stderr, _("exec failed\n"));
	}

	close(p[0]);
	dup2(p[1], STDOUT_FILENO);
	close(p[1]);
    }
#endif

    switch (bigMode) {

      case MODE_UNKNOWN:
	if (!showVersion && !help) printUsage();
	break;

      case MODE_DIRECTCTRL:
	if (!poptPeekArg(optCon)) {
	    argerror(_("no command string given for direct control"));
	}

        if (dcmdGetVerbosity() == DCMDMESS_NORMAL) {
	    dcmdSetVerbosity(DCMDMESS_VERBOSE);
	}

#if 0
	if (force) {
	    probFilter |= RPMPROB_FILTER_REPLACEPKG | 
			  RPMPROB_FILTER_REPLACEOLDFILES |
			  RPMPROB_FILTER_REPLACENEWFILES |
			  RPMPROB_FILTER_OLDPACKAGE;
	}
#endif

//	if (test)		directctrlFlags	|= DCMDTRANS_FLAG_TEST;

//	if (showPercents)	interfaceFlags	|= INSTALL_PERCENT;
//	if (showHash)		interfaceFlags	|= INSTALL_HASH;

#if 0
	while ((pkg = poptGetArg(optCon))) {
	    ec = rpmInstallSource("", pkg, &specFile, &cookie);
	    if (ec)
		break;

	    ba->rootdir = rootdir;
	    ec = build(specFile, ba, passPhrase, 0, cookie, rcfile, force, noDeps);
	    if (ec)
		break;
	    free(cookie);
	    xfree(specFile);
	}
#endif

	ec = 0;
	break;

      case MODE_DIASHOW:
	ec = 0;
	break;

      case MODE_SHELL:
	ec = 0;
	break;

      case MODE_VERIFY:
	ec = 0;
	break;

    }

    poptFreeContext(optCon);

#if 0
    if (pipeChild) {
	fclose(stdout);
	(void)waitpid(pipeChild, &status, 0);
    }
#endif

    /* keeps memory leak checkers quiet */

#if HAVE_MCHECK_H && HAVE_MTRACE
    muntrace();   /* Trace malloc only if MALLOC_TRACE=mtrace-output-file. */
#endif
    return ec;
}


