#include "system.h"

#include <stdarg.h>

#include <dcmdlib.h>

static struct err {
    int code;
    char string[1024];
} errorRec;

static dcmdErrorCallBackType errorCallback = NULL;

int dcmdErrorCode(void)
{
    return errorRec.code;
}

char *dcmdErrorCodeString(void)
{
    return NULL;
}

char *dcmdErrorString(void)
{
    return errorRec.string;
}

dcmdErrorCallBackType dcmdErrorSetCallback(dcmdErrorCallBackType cb)
{
    dcmdErrorCallBackType ocb;

    ocb = errorCallback;
    errorCallback = cb;
    
    return ocb;
}

void dcmdError(int code, char *format, ...)
{
    va_list args;

    va_start(args, format);

    errorRec.code = code;
    vsnprintf(errorRec.string, 1024, format, args);

    if (errorCallback) {
	errorCallback();
    } else {
	fputs(errorRec.string, stderr);
	fputs("\n", stderr);
    }
}
