#ifndef H_DCMDLIB
#define	H_DCMDLIB

/* This is the *only* module users of dcmdlib should need to include */

/* and it shouldn't need these :-( */

//#include <lowio.h>	// uncomment when we have the lowiolib

#ifdef __cplusplus
extern "C" {
#endif

#define	xfree(_p)	free((void *)_p)

/** messages.c **/

#define	DCMDMESS_DEBUG		1
#define	DCMDMESS_VERBOSE	2
#define	DCMDMESS_NORMAL		3
#define	DCMDMESS_WARNING	4
#define	DCMDMESS_ERROR		5
#define	DCMDMESS_FATALERROR	6

#define	DCMDMESS_QUIET		(DCMDMESS_NORMAL + 1)

void dcmdIncreaseVerbosity(void);
void dcmdSetVerbosity(int level);
int dcmdGetVerbosity(void);
int dcmdIsVerbose(void);
int dcmdIsDebug(void);
void dcmdMessage(int level, const char * format, ...);

/** dcmderr.c **/

typedef void (*dcmdErrorCallBackType)(void);

#if defined(__GNUC__)
void dcmdError(int code, char * format, ...) __attribute__ ((__format__ (__printf__, 2, 3)));
#else
void dcmdError(int code, char * format, ...);
#endif

int dcmdErrorCode(void);
char *dcmdErrorCodeString(void);
char *dcmdErrorString(void);
dcmdErrorCallBackType dcmdErrorSetCallback(dcmdErrorCallBackType);

#define DCMDERR_GDBMOPEN	-2	/* gdbm open failed */
#define DCMDERR_GDBMREAD	-3	/* gdbm read failed */
#define DCMDERR_GDBMWRITE	-4	/* gdbm write failed */
#define DCMDERR_INTERNAL	-5	/* internal DCMD error */
#define DCMDERR_DBCORRUPT	-6	/* dcmd database is corrupt */
#define DCMDERR_OLDDBCORRUPT	-7	/* old style dcmd database is corrupt */
#define DCMDERR_OLDDBMISSING	-8	/* old style dcmd database is missing */
#define DCMDERR_NOCREATEDB	-9	/* cannot create new database */
#define DCMDERR_DBOPEN		-10	/* database open failed */
#define DCMDERR_DBGETINDEX	-11	/* database get from index failed */
#define DCMDERR_DBPUTINDEX	-12	/* database get from index failed */
#define DCMDERR_NEWPACKAGE	-13	/* package is too new to handle */
#define DCMDERR_BADMAGIC	-14	/* bad magic for an DCMD */
#define DCMDERR_RENAME		-15	/* rename(2) failed */
#define DCMDERR_UNLINK		-16	/* unlink(2) failed */
#define DCMDERR_RMDIR		-17	/* rmdir(2) failed */
#define DCMDERR_PKGINSTALLED	-18	/* package already installed */
#define DCMDERR_CHOWN		-19	/* chown() call failed */
#define DCMDERR_NOUSER		-20	/* user does not exist */
#define DCMDERR_NOGROUP		-21	/* group does not exist */
#define DCMDERR_MKDIR		-22	/* mkdir() call failed */
#define DCMDERR_FILECONFLICT	-23	/* file being installed exists */
#define DCMDERR_DCMDRC		-24	/* bad line in dcmdrc */
#define DCMDERR_NOSPEC		-25	/* .spec file is missing */
#define DCMDERR_NOTSDCMD	-26	/* a source dcmd was expected */
#define DCMDERR_FLOCK		-27	/* locking the database failed */
#define DCMDERR_OLDPACKAGE	-28	/* trying upgrading to old version */
/*#define DCMDERR_BADARCH	-29	bad architecture or arch mismatch */
#define DCMDERR_CREATE		-30	/* failed to create a file */
#define DCMDERR_NOSPACE		-31	/* out of disk space */
#define DCMDERR_NORELOCATE	-32	/* tried to do improper relocatation */
/*#define DCMDERR_BADOS		-33	bad architecture or arch mismatch */
#define DCMDMESS_BACKUP		-34	/* backup made during [un]install */
#define DCMDERR_MTAB		-35	/* failed to read mount table */
#define DCMDERR_STAT		-36	/* failed to stat something */
#define DCMDERR_BADDEV		-37	/* file on device not listed in mtab */
#define DCMDMESS_ALTNAME	-38	/* file written as .dcmdnew */
#define DCMDMESS_PREREQLOOP	-39	/* loop in prerequisites */
#define DCMDERR_BADRELOCATE	-40	/* bad relocation was specified */
#define DCMDERR_OLDDB		-41	/* old format database */

/* spec.c build.c pack.c */
#define DCMDERR_UNMATCHEDIF	-107	/* unclosed %ifarch or %ifos */
#define DCMDERR_BADARG		-109
#define DCMDERR_SCRIPT		-110	/* errors related to script exec */
#define DCMDERR_READERROR	-111
#define DCMDERR_UNKNOWNOS	-112
#define DCMDERR_UNKNOWNARCH	-113
#define DCMDERR_EXEC		-114
#define DCMDERR_FORK		-115
#define DCMDERR_CPIO		-116
#define DCMDERR_GZIP		-117
#define DCMDERR_BADSPEC		-118
#define DCMDERR_LDD		-119	/* couldn't understand ldd output */
#define DCMDERR_BADFILENAME	-120

#define DCMDERR_BADSIGTYPE	-200	/* Unknown signature type */
#define DCMDERR_SIGGEN		-201	/* Error generating signature */

#ifdef __cplusplus
}
#endif

#endif	/* H_DCMDLIB */
