#include "system.h"

#include <stdarg.h>

#include <dcmdlib.h>

static int minLevel = DCMDMESS_NORMAL;

void dcmdIncreaseVerbosity(void) {
    minLevel--;
}

void dcmdSetVerbosity(int level) {
    minLevel = level;
}

int dcmdGetVerbosity(void)
{
   return minLevel;
}

int dcmdIsDebug(void)
{
    return (minLevel <= DCMDMESS_DEBUG);
}

int dcmdIsVerbose(void)
{
    return (minLevel <= DCMDMESS_VERBOSE);
}

void dcmdMessage(int level, const char * format, ...)
{
    va_list args;

    va_start(args, format);

    if (level >= minLevel) {

	switch (level) {

	  case DCMDMESS_VERBOSE:
	  case DCMDMESS_NORMAL:
	    vfprintf(stdout, format, args);
	    fflush(stdout);
	    break;
	    
	  case DCMDMESS_DEBUG:
	    if (*format != '+')
	        fprintf(stdout, "debug: ");
	    else
		format++;
	    vfprintf(stdout, format, args);
	    fflush(stdout);
	    break;

	  case DCMDMESS_WARNING:
	    if (*format != '+')
		fprintf(stderr, _("warning: "));
	    else
		format++;
	    vfprintf(stderr, format, args);
	    fflush(stderr);
	    break;

	  case DCMDMESS_ERROR:
	    if (*format != '+')
		fprintf(stderr, _("error: "));
	    else
		format++;
	    vfprintf(stderr, format, args);
	    fflush(stderr);
	    break;

	  case DCMDMESS_FATALERROR:
	    if (*format != '+')
		fprintf(stderr, _("fatal error: "));
	    else
		format++;
	    vfprintf(stderr, format, args);
	    fflush(stderr);
	    exit(EXIT_FAILURE);
	    /*@notreached@*/ break;

	  default:
	    fprintf(stderr, _("internal error (dcmdlib bug?): "));
	    vfprintf(stderr, format, args);
	    fflush(stderr);
	    exit(EXIT_FAILURE);
	    /*@notreached@*/ break;

	}
    }
}
