/*
    debug.h
    generic conventions for debugging

    This file is part of the LowIO library project
    Copyright (C) 2001 by Stephan Linz <linz@li-pro.net>

    This library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

#ifndef _DEBUG_H_
#define _DEBUG_H_ 1


__BEGIN_DECLS
#ifdef _LOWIO_C_
#define extern
#define LIO_DEBUG_TAIL	= 0;
#else
#define LIO_DEBUG_TAIL	;
#endif

/* library debug flag */
extern int LIO_Debug LIO_DEBUG_TAIL

#ifdef _LOWIO_C_
#undef extern
#endif
__END_DECLS


#ifndef DBG_PANIC
#define DBG_PANIC(format, args...)				\
	    if (LIO_Debug) {					\
		fprintf(stderr, "\a\a\aLIO_PANIC   @ %s(%i) : ",\
		    __FILE__, __LINE__);			\
		fprintf(stderr, format, ## args);		\
		fflush(stderr);					\
	    }
#endif

#ifndef DBG_ERROR
#define DBG_ERROR(format, args...)				\
	    if (LIO_Debug) {					\
		fprintf(stderr, "\aLIO_ERROR   @ %s(%i) : ",	\
		    __FILE__, __LINE__);			\
		fprintf(stderr, format, ## args);		\
		fflush(stderr);					\
	    }
#endif

#ifndef DBG_WARNING
#define DBG_WARNING(format, args...)				\
	    if (LIO_Debug) {					\
		fprintf(stderr, "LIO_WARNING @ %s(%i) : ",	\
		    __FILE__, __LINE__);			\
		fprintf(stderr, format, ## args);		\
		fflush(stderr);					\
	    }
#endif

#ifndef DBG_INFO
#define DBG_INFO(format, args...)				\
	    if (LIO_Debug) {					\
		fprintf(stderr, "LIO_INFO    @ %s(%i) : ",	\
		    __FILE__, __LINE__);			\
		fprintf(stderr, format, ## args);		\
		fflush(stderr);					\
	    }
#endif

#ifndef DBG_PRINT
#define DBG_PRINT(format, args...)				\
	    if (LIO_Debug) {					\
		fprintf(stderr, format, ## args);		\
		fflush(stderr);					\
	    }
#endif


#endif /* !_DEBUG_H_ */
