/* (C) 2001 Li-Pro.Net -- Licensing details are in the COPYING
   file accompanying lowio source distributions, available from
   http://www.li-pro.net/pub/lowio */

#define C_TEST2

#include "system.h"

int main(int argc, char **argv)
{
    LIO_Serial *		io;
    LIO_Serial_Properties	prop;
    int				bytestep = 5;
    int				wait = 1300; /* ms */
    const unsigned char		cmd_buf[] = "0901 0901 ";
 
    LIO_DebugOn();

    io = LIO_Serial_New();
    if (io == NULL) {
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_Init(io, 2)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_SetBytestep(io, &bytestep)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_GetProp(io, &prop)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    prop.bitrate.input  =
    prop.bitrate.output = 4800;
 
    prop.parameter.bits     = 8;
    prop.parameter.parity   = LIO_SERIAL_PAR_NONE;
    prop.parameter.stopbits = 2;
 
    prop.modemlines.dtr =
    prop.modemlines.rts = LIO_SERIAL_LM_LOW;
 
    if (!LIO_Serial_SetProp(io, &prop)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_GetProp(io, &prop)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_Write(io, cmd_buf, strlen(cmd_buf), wait)) {
	LIO_Serial_Close(io);
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    if (!LIO_Serial_Close(io)) {
	LIO_Serial_Delete(io);
	printf("ERROR: near line %i\n", __LINE__);
	return EXIT_FAILURE;
    }
 
    LIO_Serial_Delete(io);
 
    printf("One Step Forward ... :-)\n");
 
    return EXIT_SUCCESS;
}
