#!/bin/sh

run() {
    prog=$1; shift
    name=$1; shift
    answer=$1; shift

    echo Running test $name.

    result=`$builddir/$prog $*`
    if [ "$answer" != "$result" ]; then
	echo "Test \"$*\" failed with: \"$result\" != \"$answer\" "
	exit 2
    fi
}

builddir=`pwd`
cd ${srcdir}
test1=${builddir}/test1
echo "Running tests in `pwd`"

#make -q testcases

run test1 "test1 - 1" "LIO_Version : 0.0.1(0x000001)"
run test2 "test2 - 1" "One Step Forward ... :-)"
#run test2 "test2 - 2" "arg1: 0 arg2: foo" --arg2 foo
#run test2 "test2 - 3" "arg1: 1 arg2: something" --arg1 --arg2 something
#run test2 "test2 - 4" "arg1: 0 arg2: another" --simple another
#run test2 "test2 - 5" "arg1: 1 arg2: alias" --two
#run test2 "test2 - 6" "arg1: 1 arg2: (none) rest: --arg2" --arg1 -- --arg2 
#run test2 "test2 - 7" "arg1: 0 arg2: abcd rest: --arg1" --simple abcd -- --arg1 
#run test2 "test2 - 8" "arg1: 1 arg2: (none) rest: --arg2" --arg1 --takerest --arg2 
#run test2 "test2 - 9" "arg1: 0 arg2: foo" -2 foo
#run test2 "test2 - 10" "arg1: 0 arg2: (none) arg3: 50" -3 50

echo ""
echo "Passed."
