/*
    lio_serial.h
    serial line access

    This file is part of the LowIO library project
    Copyright (C) 2001 by Stephan Linz <linz@li-pro.net>

    Some stuff is comming from the MUSCLE Towitoko driver project
    Copyright (C) 2000 by Carlos Prados <cprados@yahoo.com>

    This library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

#ifndef _LIO_SERIAL_H_
#define _LIO_SERIAL_H_ 1


/*
 *  __BEGIN_DECLS should be used at the beginning of your declarations,
 * so that C++ compilers don't mangle their names.  Use __END_DECLS at
 * the end of C declarations.
 */
#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

/*
 * __P is a macro used to wrap function prototypes, so that compilers
 * that don't understand ANSI C prototypes still work, and ANSI C
 * compilers can issue warnings about type mismatches.
 */
#undef __P
#if defined (__STDC__) || defined (_AIX) \
        || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
        || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif


/*
 * exported constants definition
 */


/*
 * exported datatypes definition
 */

/* types of parities */
__BEGIN_DECLS
typedef enum {
    LIO_SERIAL_PAR_ODD	= 1,
    LIO_SERIAL_PAR_EVEN	= 0,
    LIO_SERIAL_PAR_NONE	= -1,
} LIO_Serial_Parity;
__END_DECLS

/* types of line modes */
__BEGIN_DECLS
typedef enum {
    LIO_SERIAL_LM_LOW	= 0,
    LIO_SERIAL_LM_HIGH	= 1,
} LIO_Serial_Linemode;
__END_DECLS

/* types of port access modes */
__BEGIN_DECLS
typedef enum {
    LIO_SERIAL_TRM_BYTEWISE	= 0,
    LIO_SERIAL_TRM_WORDWISE,
    LIO_SERIAL_TRM_DWORDWISE,
    LIO_SERIAL_TRM_DDWORDWISE,
    LIO_SERIAL_TRM_FAST,
} LIO_Serial_Transfermode;
__END_DECLS

#define LIO_SERIAL_TRM_VALSTR(VAL)						\
	    (VAL) == LIO_SERIAL_TRM_BYTEWISE   ? "LIO_SERIAL_TRM_BYTEWISE"   :	\
	    (VAL) == LIO_SERIAL_TRM_WORDWISE   ? "LIO_SERIAL_TRM_WORDWISE"   :	\
	    (VAL) == LIO_SERIAL_TRM_DWORDWISE  ? "LIO_SERIAL_TRM_DWORDWISE"  :	\
	    (VAL) == LIO_SERIAL_TRM_DDWORDWISE ? "LIO_SERIAL_TRM_DDWORDWISE" : "<unknown>"

/* settings which can be modified to the serial device */
__BEGIN_DECLS
typedef struct {
    struct {
	int			input;
	int			output;
    } bitrate;
    struct {
	int			bits;
	LIO_Serial_Parity	parity;
	int			stopbits;
    } parameter;
    struct {
	LIO_Serial_Linemode	dtr;	/* Data Terminal Ready  (out) */
	LIO_Serial_Linemode	rts;	/* Request To Send      (out) */
	LIO_Serial_Linemode	dsr;	/* Data Set Ready       (in)  */
	LIO_Serial_Linemode	cts;	/* Clear To Send        (in)  */
	LIO_Serial_Linemode	dcd;	/* Data Carrier Detect  (in)  */
	LIO_Serial_Linemode	ri;	/* Ring Indicator       (in)  */
    } modemlines;
} LIO_Serial_Properties;
__END_DECLS

/* lio contact structure for serial module */
__BEGIN_DECLS
typedef struct {
    int				fd;	/* handle of the serial device */
    int				port;	/* port number (1..n) --> (COM1..COMn) */
    LIO_Serial_Transfermode	trm;	/* access mode flag */
} LIO_Serial;
__END_DECLS


/*
 * exported functions declaration
 */
__BEGIN_DECLS
extern LIO_Serial * LIO_Serial_New __P((void));
extern void LIO_Serial_Delete __P((LIO_Serial * io));

extern int LIO_Serial_Init __P((LIO_Serial * io, int port));
extern int LIO_Serial_SetProp __P((LIO_Serial * io, LIO_Serial_Properties * prop));
extern int LIO_Serial_GetProp __P((LIO_Serial * io, LIO_Serial_Properties * prop));
extern int LIO_Serial_SetAM __P((LIO_Serial * io, LIO_Serial_Transfermode * trm));
extern int LIO_Serial_GetAM __P((LIO_Serial * io, LIO_Serial_Transfermode * trm));
extern int LIO_Serial_GetPort __P((LIO_Serial * io, int * port));
extern int LIO_Serial_Read __P((LIO_Serial * io, int bwt, size_t size, unsigned char * data));
extern int LIO_Serial_Write __P((LIO_Serial * io, int cwt, size_t size, const unsigned char * data));
extern int LIO_Serial_Close __P((LIO_Serial * io));
__END_DECLS


#endif /* !_LIO_SERIAL_H_ */
