#ifndef _SYSTEM_H_
#define _SYSTEM_H_


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


/* AIX requires this to be the first thing in the file.  */ 
#ifndef __GNUC__
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#elif defined(__GNUC__) && defined(__STRICT_ANSI__)
#define alloca __builtin_alloca
#endif


#if HAVE_MCHECK_H 
#include <mcheck.h>
#endif


#ifdef STDC_HEADERS
# include <errno.h>
# include <limits.h>
# include <locale.h>
# include <stdio.h>
# include <stdlib.h>
# include <stddef.h>
# include <stdarg.h>
#else
# error missing ANSI C header files
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <sys/ioctl.h>

#include <termios.h>
#include <fcntl.h>


#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


#ifdef __NeXT
/* access macros are not declared in non posix mode in unistd.h -
 don't try to use posix on NeXTstep 3.3 ! */
#include <libc.h>
#endif


/* <unistd.h> should be included before any preprocessor test
   of _POSIX_VERSION.  */
#if HAVE_UNISTD_H
#include <unistd.h>
#endif


/* Don't use bcopy!  Use memmove if source and destination may overlap,
   memcpy otherwise.  */

#ifdef HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
# ifndef HAVE_STRCHR		/* old BSD */
#  define strchr index
#  define strrchr rindex
char * strchr (), * strchr ();
# endif
# ifndef HAVE_MEMCPY		/* old BSD */
#  define memcpy(d, s, n) bcopy((s), (d), (n))
#  define memmove(d, s, n) bcopy((s), (d), (n))
# endif
#else
char *memchr ();
#endif


/*@only@*/ char * xstrdup (const char *str);

#if HAVE_MCHECK_H && defined(__GNUC__)
#define	vmefail()	(fprintf(stderr, "virtual memory exhausted.\n"), exit(EXIT_FAILURE), NULL)
#define xstrdup(_str)   (strcpy((malloc(strlen(_str)+1) ? : vmefail()), (_str)))
#else
#define	xstrdup(_str)	strdup(_str)
#endif  /* HAVE_MCHECK_H && defined(__GNUC__) */


/* utility macros */
#ifndef MAX
#define MAX(A,B)			( (A) > (B) ? (A) : (B) )
#endif
 
#ifndef MIN
#define MIN(A,B)			( (A) < (B) ? (A) : (B) )
#endif
 
#ifndef ANY_BIT_SET
#define ANY_BIT_SET(MASK,VAL)		( ((VAL) & (MASK)) != 0 ? 1 : 0 )
#endif
 
#ifndef ALL_BITS_SET
#define ALL_BITS_SET(MASK,VAL)		( ((VAL) & (MASK)) == (MASK) ? 1 : 0 )
#endif
 
#ifndef ANY_BIT_UNSET
#define ANY_BIT_UNSET(MASK,VAL)		( /* TODO: nice to have */ )
#endif
 
#ifndef ALL_BITS_UNSET
#define ALL_BITS_UNSET(MASK,VAL)	( /* TODO: nice to have */ )
#endif



#include "lowio.h"
#include "debug.h"


#endif /* !_SYSTEM_H_ */
