/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <avrhal/ow.h>
#include <avrhal/ds1820.h>
#include "ds1820_private.h"

signed int ds1820_temp10_C(unsigned char device)
{
	unsigned char buf[9];
	signed int temp;

	if (!ds1820_convert(device)) return -9999;	/* update temperature */
	if (!ow_function(0xbe, device))				/* get new temperature */
		return -9999;

	if(!ow_buf_read(buf, sizeof(buf), 1 /* crc included, check it */))
		return -9999;

	buf[8] = 0;									/* sign flag set to false */
	temp = (buf[1] << 8) + buf[0];

	if (temp < 0) {
		buf[8] = 1;								/* negative */
		temp = -temp;
	}

	temp >>= 1;									/* vorkommastellen */
	temp *= 10;
	if (buf[0] & 1) temp += 5;					/* nachkommastellen */
	if (buf[8]) temp = -temp;					/* restore sign */

	return temp;
}

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
