/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <string.h>
#include <avrhal/ow.h>
#include <avrhal/ds1820.h>
#include "ds1820_private.h"

int ds1820_temperature_10(unsigned char *addr)
{
	unsigned char device;

	for (device = 0; device < _ow_devices_active; device++) {

		if (!memcmp((void *)addr, (void *)&(_ow_devices[device].rom_code),
					sizeof(ow_rom_code_st)))
			return (int)ds1820_temp10_C(device);
	}

	return -9999;
}

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
