/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <avrhal/crc.h>
#include <avrhal/ow.h>

extern unsigned char _ow_reset(void);

/*
 * Read a whole buffer from 1-Wire bus and check crc on demand.
 */
unsigned char ow_buf_read(unsigned char *buf, size_t buf_size, unsigned char crc_included)
{
	unsigned char	i;

	for (i = 0; i < buf_size; i++) {
		buf[i] = ow_byte_read();
	}

	if (!_ow_reset())
		return 0;

	if (crc_included)
		if (crc8_ow(buf, buf_size))
			return 0;		/* there was an transmit error */
		else
			return 1;
	else
		return 1;
}

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
