/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <avrhal/ow.h>

extern unsigned char _ow_reset(void);

extern unsigned char _ow_devices_active;
extern ow_device_st *_ow_devices;

/*
 * generic command initiation
 */
unsigned char ow_function(unsigned char code, unsigned char device)
{
	if (!_ow_devices_active		/* device was not initialized */
			|| !(device < _ow_devices_active))
		return 0;

	if (!_ow_reset())			/* it seems, there is no device anymore */
		return 0;

#if AVRHAL_LIB_OW_DEVS == OW_ONE_DEV
	ow_byte_write(0xcc);		/* SKIP ROM command */
#elif AVRHAL_LIB_OW_DEVS == OW_MANY_DEV
	ow_byte_write(0x55);		/* MATCH ROM command */
	ow_buf_write((unsigned char *)&(_ow_devices[device].rom_code),
			sizeof(ow_rom_code_st), 0 /* don't generate crc */);
#else
#error *** missing or incorrect AVRHAL_LIB_OW_DEVS setting
#endif

	ow_byte_write(code);

	return 1;
}

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
