/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <avrhal/crc.h>

/*
 * Dallas One Wire CRC-8 generator / checker
 */
#ifdef L_crc8_ow
unsigned char crc8_ow(unsigned char *buf, size_t buf_size)
{
	unsigned char crc8, byte, bit;

	crc8 = 0;
	while (buf_size--) {
		byte = *buf++;
		for (bit = 8; bit; bit--) {
			if (((byte & 1) ^ crc8) & 1) {
				crc8 = (((crc8 ^ 0x18) >> 1) | 0x80);
			} else {
				crc8 = ((crc8 >> 1) & ~0x80);
			}
			byte >>= 1;
		}
	}

	return crc8;
}
#endif

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
