/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include "macros.inc"
#include "ctoasm.inc"
#include "avrhal/delay.h"

#ifndef AVRHAL_LIB_DELAY_1MS_COUNT
#error *** missing AVRHAL_LIB_DELAY_1MS_COUNT
#endif

	.text
	.global	_U(delay_ms)
	.type	_U(delay_ms), @function
_U(delay_ms):
	LOAD_Z(rP1, rP0)
	adiw	r30, 0
	breq	.delay_ms_return
.delay_ms_loop0:
	LOAD_X_CONST(AVRHAL_LIB_DELAY_1MS_COUNT)
.delay_ms_loop1:
	sbiw	r26, 1
	brne	.delay_ms_loop1
	wdr
	sbiw	r30, 1
	brne	.delay_ms_loop0
.delay_ms_return:
	ret
.delay_ms_end:
	.size _U(delay_ms), .delay_ms_end - _U(delay_ms)

