/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include "macros.inc"
#include "ctoasm.inc"
#include "avrhal/delay.h"

#if AVRHAL_LIB_HZ != 8000000
#warning *** unsupported frequency configuration, delay_us() may damaged
#endif

	.text
	.global	_U(delay_us)
	.type	_U(delay_us), @function
_U(delay_us):
	LOAD_Z(rP1, rP0)
	adiw	r30, 0
	breq	.delay_us_return
; TODO: include more or less nops dependent on system clock freq
.delay_us_loop:
	nop
	nop
	nop
	nop
	sbiw	r30, 1
	brne	.delay_us_loop
.delay_us_return:
	ret
.delay_us_end:
	.size _U(delay_us), .delay_us_end - _U(delay_us)
