#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/lcd.h>

uint16_t cnt = 0;

SIGNAL(SIG_OVERFLOW0)
{
	cnt++;
}

int main(void)
{
	outp(BV(CS02)|BV(CS00),	TCCR0);	// tmr0 @ 7,8125 kHz
	timer_enable_int(BV(TOIE0));
	sei();

	lcd_init((2 /* rows */ << 6) + 16 /* columns */);
	lcd_putstr("--= AVR-Ctrl =--");
	lcd_putstr("Counter = ");
	lcd_control(1, 0, 0);			// cursor block off

	while (1)
	{
		lcd_gotoxy(10,1);
		lcd_print5(cnt);
	}
} /* main() */

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
