#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/lcd.h>
#include <avrhal/ow.h>
#include <avrhal/ds1820.h>

int main(void)
{
	unsigned char ow_devices[2 * 9];
	unsigned char devices;

	lcd_init((2 /* rows */ << 6) + 16 /* columns */);
	lcd_putstr("--= AVR-Ctrl =--");
	lcd_putstr("T");
	lcd_control(1, 0, 0);			// cursor block off

	w1_init();								// NO ERROR HANDLING !!!
	devices = w1_search(0xf0, ow_devices);	// NO ERROR HANDLING !!!

	while (1)
	{
		uint8_t dev;

		for (dev = 0; dev < devices; dev++) {

			int temp = ds1820_temperature_10(&(ow_devices[dev * 9]));

			lcd_gotoxy(1,1);
			lcd_printf("%d = %d.%c %cC", dev + 1, temp / 10,
					temp % 10 + 0x30, 0xdf);

			delay_ms(2000);
		}
	}
} /* main() */

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
