#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/lcd.h>

#define	b0000000	0x00
#define	b0001111	0x0f
#define	b0000011	0x03
#define	b0000101	0x05
#define	b0001001	0x09
#define	b0010000	0x10
#define	b0100000	0x20
#define	b1000000	0x40

/* table for the LCD user defined character:
 * arrow that points to the top right corner */
unsigned char arrow[8] = {
	b0000000,
	b0001111,
	b0000011,
	b0000101,
	b0001001,
	b0010000,
	b0100000,
	b1000000
};

/* function used to define user characters */
void define_char(unsigned char *pc, unsigned char char_code)
{
	unsigned char i, a;

	a = ( char_code << 3 ) | 0x40;
	for (i = 0; i < 8; i++) lcd_write_byte(a++, *pc++);
}


void main(void)
{
	/* initialize the LCD for 2 lines and 16 colums */
	lcd_init(16);

	/* define first user character with arrow */
	define_char(arrow, 0);

	/* switch to writing in Display RAM */
	lcd_gotoxy(0, 0);
	lcd_puts("User char 0: ");

	/* display first user character */
	lcd_putchar(0);

	while (1); /* loop for ever */
}
