#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/key.h>
#include <avrhal/lcd.h>


int main(void)
{
	uint8_t scancode, scroll_pos = 0;
	uint8_t scroll[] = " press a key.. ";

	key_init();
	lcd_init((2 /* rows */ << 6) + 16 /* columns */);
	lcd_control(1, 0, 0);			// cursor block off

	while (1)
	{
		scancode = key_scancode();

		lcd_clear();
		lcd_gotoxy(4,1);
		lcd_printhex(scancode);
		lcd_gotoxy(10,1);
		lcd_print3(scancode);

		lcd_gotoxy(0,0);
		lcd_putstr(&scroll[strlen(scroll) - 1 - (scroll_pos++ >> 3)]);
		if (scroll_pos == 8 * strlen(scroll)) scroll_pos = 0;

		delay_us(25000);
	}
} /* main() */




/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
