#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/led.h>

enum {
	UP,
	DOWN
} direction;

int main(void)
{
	uint8_t led = 0x01;

	led_init();

	while (1)
	{
		led_put(led);
		delay_ms(100);

		/* direction state machine */
		switch (direction)
		{
			case UP:
				/* count up means
				 * shift left */
				led <<= 1;
				if (!led)
				{
					/* change direction */
					led = 0x80;
					direction = DOWN;
				}
				break;

			case DOWN:
				/* count down means
				 * shift right */
				led >>= 1;
				if (!led)
				{
					/* change direction */
					led = 0x01;
					direction = UP;
				}
				break;

			default:
				break;
		}
	}
} /* main() */




/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
