#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/led.h>

#define MAX_LEVEL 32

enum {
	UP,
	DOWN
} direction;

int main(void)
{
	int8_t led = 0;

	led_init();
	led_graph_control(2*MAX_LEVEL, LED_BAR | LED_MARGIN(/* Bit */ 4 /* is margin */));

	while (1)
	{
		led_graph_put((int16_t)led);
		delay_ms(10);

		/* direction state machine */
		switch (direction)
		{
			case UP:
				/* count up means
				 * shift left */
				led++;
				if (led == MAX_LEVEL)
				{
					/* change direction */
					direction = DOWN;
				}
				break;

			case DOWN:
				/* count down means
				 * shift right */
				led--;
				if (led == -MAX_LEVEL)
				{
					/* change direction */
					direction = UP;
				}
				break;

			default:
				break;
		}
	}
} /* main() */

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
