#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <inttypes.h>

#include <avrhal/delay.h>
#include <avrhal/lcd.h>
#include <avrhal/ow.h>

int main(void)
{
	ow_device_st devarray[2];
	unsigned char devices;
	unsigned int  waiting = 5000;

	lcd_init((2 /* rows */ << 6) + 16 /* columns */);
	lcd_putstr("--= AVR-Ctrl =--");
	lcd_control(1, 0, 0);			// cursor block off

	if (!ow_init()) {
		lcd_putstr("ERROR: ow_init()");
		while (1);
	}

	devices = ow_rom_search(devarray);

	while (1)
	{
		unsigned char dev;

		lcd_gotoxy(0,1); lcd_cleol();
#ifdef __AVRHAL_LIB_SMALL
		lcd_putstr("OW_DEVICES: ");
		lcd_print2(devices);
#else
		lcd_printf("OW_DEVICES: %d", devices);
#endif
		delay_ms(waiting);

		for (dev = 0; dev < devices; dev++) {

			unsigned char snidx;
#ifdef __AVRHAL_LIB_SMALL
			unsigned char *cp = (unsigned char *)&(devarray[dev].rom_code);
#endif

			lcd_gotoxy(0,1); lcd_cleol();
#ifdef __AVRHAL_LIB_SMALL
			for (snidx = 0; snidx < sizeof(ow_rom_code_st); snidx++) {
				lcd_printhex(cp[snidx]);
			}
#else
			lcd_printf("%x", devarray[dev].rom_code.family);
			for (snidx = 0; snidx < 6; snidx++) {
				lcd_printf("%x", devarray[dev].rom_code.serial[snidx]);
			}
			lcd_printf("%x", devarray[dev].rom_code.crc);
#endif
			delay_ms(waiting);
		}
	}
} /* main() */

/*************************************EndOfFile***************************
$Id: $
vim:tw=78:ts=4:sw=4:ai:
*/
