/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

/*
   avrhal/crc.h - specialized CRC
 */

#ifndef _AVRHALL_CRC_H_
#define _AVRHALL_CRC_H_ 1

#if defined(HAVE_CONFIG_H) && defined(AVRHAL_LIB_SRC)
#include <config.h>
#else
#include <avrhal/config.h>
#endif

#ifndef __ASSEMBLER__

#define __need_size_t
#include <stddef.h>

/** \defgroup avrhal_crc CRC Berechnungen
    \anchor a_avrhal_crc
    \code #include <avrhal/crc.h> \endcode

    Diese Headerdatei deklariert eine Sammlung von Funktionen fr die
    Berechnung spezieller CRC Summen. Im Regelfall fhren die Funktionen
    keinerlei Tests auf Speicherberlufe oder NULL Zeiger Referenzierung
    durch.

    Fr die Erstellung dieses Codes wurden folgende Referenzen benutzt:
    \ref supp_crc_footnote_one	"[1]".

    \anchor supp_crc_footnote_one
    \note <b>[1]</b> Dallas Semiconductor Application Note 27 "Understanding and Using CRC"
    
    \warning Unter Umstnden wird dieser Teil der Bibliothek in Zukunft
    in die Sandard C Bibliothek fr AVR Controller, \em avrlibc, bergehen. */

/** \name Dallas One Wire */

/*@{*/

#ifdef __cplusplus
extern "C" {
#endif

/** \fn unsigned char crc8_ow(unsigned char *buf, size_t buf_size)
    \ingroup avrhal_crc
    \brief 8 Bit CRC Summenberechnung

    Mit dieser Funktion wird die im One Wire Bus benutzte 8 Bit CRC Summe
    ber den mit \em data und \em length referenzierten Puffer berechnet.
    Die Berechnung erfolgt nach den Anweisungen aus
    \ref supp_crc_footnote_one "[1]".

    \param buf Zeiger auf den Anfang des Puffers.
    \param buf_size Anzahl der Bytes im Puffer (Gre).
    
    \return Die Funktion crc8_ow() gibt die berechnete CRC Summe zurck. */
extern unsigned char crc8_ow(unsigned char *buf, size_t buf_size);

#ifdef __cplusplus
}
#endif

/*@}*/

#endif /* __ASSEMBLER__ */

#endif /* _AVRHALL_CRC_H_ */
