/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

/*
   avrhal/delay.h - loops for small accurate delays (like avr/delay.h)
 */

#ifndef _AVRHALL_DELAY_H_
#define _AVRHALL_DELAY_H_ 1

#if defined(HAVE_CONFIG_H) && defined(AVRHAL_LIB_SRC)
#include <config.h>
#else
#include <avrhal/config.h>
#endif

#ifndef __ASSEMBLER__

/** \defgroup avrhal_delay Verzgerungen
    \anchor a_avrhal_delay
    \code #include <avrhal/delay.h> \endcode

    Diese Headerdatei deklariert eine Sammlung von Funktionen fr die
    \b ungenaue Unterbrechung bzw. Verzgerung linear ablaufender Anweisungen.
    Diese Funktionen sind unabhngig von einer festen Zeitbasis, wie z.B. ein
    Timer. Ihre Implementation ist \b immer von der zugrunde liegenden
    Taktfrequenz der CPU abhngig. Der Ablauf der Funktionen, also demnach
    auch die Verzgerung, kann durch unvorhergesehene Ereignisse, wie die
    Behandlung eines Interrupt, verlngert werden.

    \todo Ausbau der Untersttzung verschiedener CPU Taktfrequenzen, speziell
    fr delay_us(). */

/** \name Deklarationen mit Abhngigkeit vom Systemtakt */

/*@{*/

#ifdef __cplusplus
extern "C" {
#endif

/** \fn void delay_ms(unsigned int msec)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von Millisekunden.

    Die Funktion delay_ms() unterbricht die Ausfhrung der aufrufenden Instanz
    fr \em msec Millisekunden. Die Unterbrechung kann durch Systemaktivitten,
    z.B. Interrupts, oder durch die Zeit, die zum Bearbeiten des Aufrufs
    verwendet wird, verlngert werden.

    Der regulre Jitter betrgt etwa 0,29 % der Gesamtverzgerung. Die
    Funktion delay_ms() benutzt den WDR Aufruf, um ein eventuelles Reset durch
    den Watchdog zu vermeiden.

    \returns Die Funktion delay_ms() besitzt keinen Rckgabewert. */
extern void delay_ms(unsigned int msec);

/** \fn void delay_us(unsigned int usec)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von Mikrosekunden.

    Die Funktion delay_us() unterbricht die Ausfhrung der aufrufenden Instanz
    fr \em usec Mikrosekunden. Die Unterbrechung kann durch Systemaktivitten,
    z.B. Interrupts, oder durch die Zeit, die zum Bearbeiten des Aufrufs
    verwendet wird, verlngert werden.

    \returns Die Funktion delay_us() besitzt keinen Rckgabewert. */
extern void delay_us(unsigned int usec);

#ifdef __cplusplus
}
#endif

/*@}*/

/** \name Deklarationen unabhngig vom Systemtakt */

/*@{*/

#ifdef __cplusplus
extern "C" {
#endif

/** \fn void delay_9T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 9 Systemtakten. */
extern void delay_9T(void);

/** \fn void delay_8T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 8 Systemtakten. */
extern void delay_8T(void);

/** \fn void delay_7T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 7 Systemtakten. */
extern void delay_7T(void);

/** \fn void delay_6T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 6 Systemtakten. */
extern void delay_6T(void);

/** \fn void delay_5T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 5 Systemtakten. */
extern void delay_5T(void);

/** \fn void delay_4T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 4 Systemtakten. */
extern void delay_4T(void);

/** \fn void delay_3T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 3 Systemtakten. */
extern void delay_3T(void);

/** \fn void delay_2T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 2 Systemtakten. */
extern void delay_2T(void);

/** \fn void delay_1T(void)
    \ingroup avrhal_delay
    \brief Unterbricht die Ausfhrung fr einen Intervall von 1 Systemtakt. */
extern void delay_1T(void);

#ifdef __cplusplus
}
#endif

/*@}*/

#endif /* __ASSEMBLER__ */

#endif /* _AVRHALL_DELAY_H_ */
