/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    Some code comes from Brajer Vlado <vlado.brajer@kks.s-net.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <stdarg.h>
#include <avrhal/lcd.h>

void lcd_printf(const char *format, ...)
{
	static const char hex[] = "0123456789ABCDEF";
	char format_flag;
	unsigned int u_val, div_val, base;
	// not used (TODO): char *ptr;
	va_list ap;

	va_start (ap, format);
	for (;;) {
		while ((format_flag = *format++) != '%') {      // Until '%' or '\0'
			if (!format_flag) {
				va_end (ap);
				return;
			}
			lcd_putch (format_flag);
		}

		switch (format_flag = *format++) {
			case 'c':	format_flag = va_arg(ap, int);
			default:	lcd_putch(format_flag);
					continue;
			case 'u':
			case 'd':	base = 10;
					div_val = 10000;
					goto CONVERSION_LOOP;
			case 'x':	base = 16;
					div_val = 0x10;
CONVERSION_LOOP:
					u_val = va_arg(ap, int);
					if (format_flag < 'x') {
						if ((format_flag == 'd') && (((int)u_val) < 0)) {
							u_val = - u_val;
							lcd_putch ('-');
						}
						while (div_val > 1 && div_val > u_val)
							div_val /= 10;
					}
					do {
						lcd_putch (hex[u_val / div_val]);
						u_val %= div_val;
						div_val /= base;
					} while (div_val);
				}
	}
}
