/*
    Copyright (C) 2003 by Stephan Linz <linz@li-pro.net>

    Some code comes from Brajer Vlado <vlado.brajer@kks.s-net.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Bosten, MA 02111-1307 USA
*/

/* $Id: $ */

#include <avrhal/lcd.h>

void lcd_printhex(unsigned char x)
{
	unsigned char hi, lo;

	hi = x & 0xF0;		// High nibble
	hi = hi >> 4;
	hi = hi + '0';
	if (hi > '9')
		hi = hi + 7;

	lo = (x & 0x0F) + '0';	// Low nibble
	if (lo > '9')
		lo = lo + 7;

	lcd_putch(hi);
	lcd_putch(lo);
}
